<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form;

use Pongho\Form\Subject\ModelSubject;

/**
 * Subject filter
 */
class FilterSubject extends ModelSubject
{
    /**
     * {@inheritdoc}
     */
    public function set($property, $value)
    {
        if ($property === 'filter') {
            $this->model->$property = serialize(array_values($value));

            return $this;
        }

        if (array_key_exists($property, $this->setters)) {
            call_user_func($this->setters[$property], $this, $value, $property);
        } else {
            $this->model->$property = $value;
        }

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function get($property)
    {
        if ($property === 'filter') {
            if ($this->model->$property) {
                $rows = unserialize($this->model->$property);

                foreach ($rows as &$row) {
                    $row = new FilterRowSubject($row);
                }

                return $rows;
            }

            return [];
        }

        if (array_key_exists($property, $this->getters)) {
            return call_user_func($this->getters[$property], $this, $property);
        }

        return $this->model->$property;
    }
}
