<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Field;

use Pongho\Form\Field\ChecklistField;

/**
 * Estendo la classe ChecklistField per poterla gestire meglio lato generatore
 */
class TableChecklistField extends ChecklistField
{
    /**
     * {@inheritdoc}
     */
    public function getTag()
    {
        $rows = [];
        foreach ($this->getOptions() as $value => $label) {
            $this->setAttribute('value', $value);
            $this->delAttribute('checked');

            if (in_array($value, $this->getValue())) {
                $this->setAttribute('checked', 'checked');
            }

            $rows[] = $this->renderRow($label);
        }

        $rows = implode(PHP_EOL, $rows);

        $header_label = $this->getSetting('header_label');
        $header_row = <<<HTML
            <tr>
                <th class="ckb">&nbsp;</th>
                <th class="main">{$header_label}</th>
            </tr>
HTML;

        return <<<HTML
            <table class="pongho-table">
				<thead>{$header_row}</thead>
				<tfoot>{$header_row}</tfoot>
				<tbody>{$rows}</tbody>
			</table>
HTML;
    }

    /**
     * {@inheritdoc}
     */
    protected function renderRow($label)
    {
        return <<<HTML
		<tr>
			<td class="ckb"><input {$this->getAttributesCode()}/></td>
			<td class="main">{$label}</td>
		</tr>
HTML;
    }
}
