<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Field;

use Application\Core\Model\LinkType;
use Pongho\Form\Field\SelectField;

/**
 * @deprecated
 */
class LinkTypeField extends SelectField
{
    /**
     * {@inheritdoc}
     */
    public function getTag()
    {
        $link_field_class = $this->getSetting('link_type_field');
        $lang = $this->getSetting('localization');
        $site = $this->getSetting('site');

        /** @var \Application\Admin\Form\LinkField\LinkField $link_field */
        $link_field = new $link_field_class(null, $this->getKey(), ['site' => $site, 'lang' => $lang, 'template_html' => $this->getGenerator()]);

        $language_id = $this->getLanguageId();

        return $link_field->render($this->getName(), $language_id, $this->getLinkType());
    }

    /**
     * Ricavo il modello LinkType dalla proprietà del Subject che si chiama come questo campo
     *
     * @return \Application\Core\Model\LinkType
     */
    protected function getLinkType()
    {
        $property = $this->getKey();

        $link_type_id = $this->getForm()->getSubject()->get($property);

        return LinkType::find($link_type_id);
    }

    /**
     * @return \Application\Core\Model\LinkType
     */
    public function getValueRaw()
    {
        return $this->getLinkType();
    }

    /**
     * @return null|int
     */
    protected function getLanguageId()
    {
        return null;
    }
}
