<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

/**
 * Campo data.
 *
 * @deprecated
 */
class DateField extends TextField
{
    /**
     * {@inheritdoc}
     */
    public function setAttributeModel()
    {
        if (isset($_POST[$this->post_name])) {
            $column = $this->model->column($this->attribute_name);

            if (empty($_POST[$this->post_name]) && !is_null($column) && $column->nullable) {
                $this->model->{$this->attribute_name} = null;
            } else {
                $this->model->{$this->attribute_name} = htmlspecialchars(trim((string) $_POST[$this->post_name]));
            }
        } else {
            $this->model->{$this->attribute_name} = $this->default;
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function getFieldValue()
    {
        $column = $this->model->column($this->attribute_name);

        if ($this->model->attributePresent($this->attribute_name)) {
            if (empty($this->model->{$this->attribute_name}) && !is_null($column) && $column->nullable) {
                return '';
            } elseif (($datetime = $this->model->{$this->attribute_name}) === null) {
                return '';
            }
        } elseif (empty($this->model->{$this->attribute_name}) && !is_null($column) && $column->nullable) {
            return '';
        } else {
            $datetime = new \DateTime();
        }

        return $datetime->format('Y-m-d');
    }

    /**
     * {@inheritdoc}
     */
    protected function getFieldClass()
    {
        return 'input_date';
    }
}
