<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

/**
 * Base per i campi checkbox.
 *
 * @deprecated
 */
class CheckboxField extends Field
{
    /**
     * {@inheritdoc}
     */
    protected $default = false;

    /**
     * {@inheritdoc}
     */
    public function setAttributeModel()
    {
        $this->model->{$this->attribute_name} = isset($_POST[$this->post_name]) && (bool) $_POST[$this->post_name];
    }

    /**
     * {@inheritdoc}
     */
    public function getViewCode()
    {
        $attributes = array_merge($this->getBaseAttributes(), [
            'name' => $this->post_name,
            'id'   => 'field-' . $this->post_name,
            'type' => 'checkbox',
        ]);

        $checked = $this->model->attributePresent($this->attribute_name) && $this->model->{$this->attribute_name} !== null ? $this->model->{$this->attribute_name} : $this->default;

        if ($checked) {
            $attributes['checked'] = 'checked';
        }

        $html = $this->get('subject')->getContainer()->get('template_html');

        return $html->generateTagInline('input', $attributes);
    }
}
