<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Widgets\Stats\View\GoogleChart\ChartFactory;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class WidgetsServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('widget_google_chart_factory', function (Container $container): ChartFactory {
            return new ChartFactory($container->get('admin.template_head'));
        });
    }
}
