<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Template\HeadHelper;
use Pongho\Template\Helper\Css;
use Pongho\Template\Helper\JavaScript;

class TemplatingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('admin.template_head', function (Container $container): HeadHelper {
            $head = new HeadHelper(
                null,
                null,
                $container->get('admin.css'),
                null,
                $container->get('admin.footer_js'),
            );

            $head->setTitle($container->get('translator')->trans('Admin panel'));

            return $head;
        });

        $container->share('admin.css', function (): Css {
            $css = new Css();

            $css->add(
                pongho_url(
                    '/Application/Admin/Resources/css/style.css?v=' . filemtime(
                        PONGHO_PATH . '/Application/Admin/Resources/css/style.css',
                    ),
                ),
            );

            return $css;
        });

        $container->share('admin.footer_js', function (): JavaScript {
            $js = new JavaScript();

            $js->add(
                pongho_url(
                    '/Application/Admin/Resources/js/main.js?v=' . filemtime(
                        PONGHO_PATH . '/Application/Admin/Resources/js/main.js',
                    ),
                ),
            );

            return $js;
        });
    }
}
