<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Routes\PonghoRoute;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\RoutesCollection;

class RoutingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend(
            'routes_collection',
            function (RoutesCollection $collection, Container $container): void {
                if ($collection->has('pongho')) {
                    $collection->del('pongho');
                }

                if (str_starts_with((string) $container->get('request')->getPathInfo(), '/pongho/')) {
                    $route = new PonghoRoute(
                        $container->get('admin_sidebar'),
                        $container->get('current_user'),
                        $container->get('main_site'),
                        $container->get('pongho_url'),
                        $container->get('admin.http_not_found_response_factory')
                    );

                    $collection->add('pongho', $route, -10);
                }
            }
        );
    }
}
