<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Utilities\HttpNotFoundResponseFactory;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class ResponseFactoryServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->set(
            'admin.http_not_found_response_factory',
            function (Container $container): HttpNotFoundResponseFactory {
                return new HttpNotFoundResponseFactory(
                    $container->get('admin_controller_helper'),
                    $container->get('admin_bar_renderer')
                );
            }
        );
    }
}
