<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Dashboard\GoogleAnalyticsAccessToken;
use Application\Admin\Dashboard\GoogleAnalyticsApiLoader;
use Application\Admin\Dashboard\Widget\KeywordsReportWidget;
use Application\Admin\Dashboard\Widget\LocationsReportWidget;
use Application\Admin\Dashboard\Widget\PageviewsReportWidget;
use Application\Admin\Dashboard\Widget\VisitsReportWidget;
use Application\Admin\Widget\Stats\Collection;
use Application\Admin\Widget\StatsWidget;
use Application\Admin\Widget\WidgetsCollection;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Sdk\GoogleAnalytics\EmbedApi\AccessToken;

class DashboardWidgetsServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('admin_dashboard_widgets', function (Container $container): WidgetsCollection {
            $widgets = new WidgetsCollection();

            /**
             * @var \Application\Core\User                       $user
             * @var \Application\Core\Model\Site                 $site
             * @var \Application\Core\Utilities\ControllerHelper $helper
             */
            $user = $container->get('current_user');
            $site = $container->get('site');
            $helper = $container->get('controller_helper');

            if ($site->getOption('gapi_view_id')) {
                if ($user->hasPermit('admin.dashboard.widget_visitsreport')) {
                    $widgets->add($container->get('admin_dashboard_visits_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_locationsreport')) {
                    $widgets->add($container->get('admin_dashboard_locations_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_keywordsreport')) {
                    $widgets->add($container->get('admin_dashboard_keywords_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_pageviewsreport')) {
                    $widgets->add($container->get('admin_dashboard_page_views_report_widget'));
                }
            }

            if ($user->hasPermit('admin.dashboard.widget_statsreport')) {
                $widgets->add($container->get('admin_dashboard_stats_widget'));
            }

            $widgets = $helper->filter($this, 'admin.dashboard.filter_widget_collection', $widgets);

            $widgets->setHeaders();

            return $widgets;
        });

        $container->share(
            'admin_dashboard_visits_report_widget',
            function (Container $container): VisitsReportWidget {
                return new VisitsReportWidget(
                    $container->get('translator'),
                    $container->get('google_analytics_api_loader'),
                );
            },
        );

        $container->share(
            'admin_dashboard_locations_report_widget',
            function (Container $container): LocationsReportWidget {
                return new LocationsReportWidget(
                    $container->get('translator'),
                    $container->get('google_analytics_api_loader'),
                );
            },
        );

        $container->share(
            'admin_dashboard_keywords_report_widget',
            function (Container $container): KeywordsReportWidget {
                return new KeywordsReportWidget(
                    $container->get('translator'),
                    $container->get('google_analytics_api_loader'),
                );
            },
        );

        $container->share(
            'admin_dashboard_page_views_report_widget',
            function (Container $container): PageviewsReportWidget {
                /** @var \Application\Core\Model\Site $site */
                $site = $container->get('site');

                return new PageviewsReportWidget(
                    $container->get('translator'),
                    $container->get('google_analytics_api_loader'),
                    $site->getDomain(),
                );
            },
        );

        $container->share(
            'admin_dashboard_stats_widget',
            function (Container $container): StatsWidget {
                return new StatsWidget(
                    $container->get('admin_dashboard_stats_collection'),
                    $container->get('translator'),
                    $container->get('event_dispatcher'),
                );
            },
        );

        $container->share('admin_dashboard_stats_collection', function (): Collection {
            return new Collection();
        });

        $container->share(
            'google_analytics_access_token',
            function (Container $container): GoogleAnalyticsAccessToken {
                return new GoogleAnalyticsAccessToken(
                    __DIR__ . '/../Resources/analytics/pongho-analytics-c25ed3b4b8b4.json',
                    $container->get('cache'),
                );
            },
        );

        $container->share(
            'google_analytics_api_loader',
            function (Container $container): GoogleAnalyticsApiLoader {
                /** @var \Application\Core\Model\Site $site */
                $site = $container->get('site');

                return new GoogleAnalyticsApiLoader(
                    $site->getOption('gapi_view_id'),
                    $container->get('google_analytics_access_token'),
                    $container->get('admin.footer_js'),
                );
            },
        );
    }
}
