<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Admin\Controller\DashboardController;
use Application\Admin\Controller\WidgetsController;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('admin_sidebar', function (Container $container): Sidebar {
            /**
             * @var \Application\Core\I18n\Translation\Translator $translator
             * @var \Application\Core\User                        $user
             */
            $translator = $container->get('translator');
            $user = $container->get('current_user');

            $sidebar = new Sidebar(
                $container->get('site'),
                $container->get('request'),
                $container->get('pongho_url'),
            );

            // Dashboard
            $sidebar->addPanel($translator->trans('Dashboard'), 'dashboard', 'dashboard', Sidebar::POS_DASHBOARD);
            $sidebar->addItem($translator->trans('Dashboard'), '/', 'dashboard', 0, DashboardController::class);

            if ($user->hasPermit('admin.options.')) {
                $sidebar->addPanel($translator->trans('Options'), 'options', 'settings', Sidebar::POS_SETTINGS);
            }

            if ($user->isFounder()) {
                $sidebar->addPanel($translator->trans('Settings'), 'settings', 'settings', Sidebar::POS_SETTINGS);
            }

            // Rotte per la gestione del multisito e dei widget in bacheca.
            $sidebar->addRoute('/widget/', WidgetsController::class);

            return $sidebar;
        });
    }
}
