<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\AdminBar\AdminBar;
use Application\Admin\AdminBar\AdminBarBuilder;
use Application\Admin\AdminBar\AdminBarRenderer;
use Application\Admin\AdminBar\Filler\AdminFiller;
use Application\Admin\AdminBar\Filler\DbProfilerFiller;
use Application\Admin\AdminBar\Filler\UserFiller;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class AdminBarServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('admin_bar', function (): AdminBar {
            return new AdminBar();
        });

        $container->share('admin_bar_builder', function (Container $container): AdminBarBuilder {
            /**
             * @var \Application\Core\User $user
             * @var \Pongho\Core\Kernel    $kernel
             */
            $user = $container->get('current_user');
            $kernel = $container->get('kernel');

            $builder = new AdminBarBuilder($container->get('admin_bar'));

            $builder->add($container->get('admin_bar_admin_filler'));
            $builder->add($container->get('admin_bar_user_filler'));

            if ($user->isFounder() && $kernel->isDebug()) {
                $builder->add($container->get('admin_bar_db_profiler_filler'));
            }

            return $builder;
        });

        $container->share('admin_bar_renderer', function (Container $container): AdminBarRenderer {
            return new AdminBarRenderer(
                $container->get('admin_bar_builder'),
            );
        });

        $container->share('admin_bar_admin_filler', function (Container $container): AdminFiller {
            return new AdminFiller(
                $container->get('site'),
                $container->get('current_user'),
                $container->get('translator'),
                $container->get('site_manager'),
            );
        });

        $container->share('admin_bar_user_filler', function (Container $container): UserFiller {
            return new UserFiller(
                $container->get('site'),
                $container->get('current_user'),
                $container->get('translator'),
            );
        });

        $container->share('admin_bar_db_profiler_filler', function (Container $container): DbProfilerFiller {
            return new DbProfilerFiller(
                $container->get('db_profiler'),
            );
        });
    }
}
