<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Dashboard\Widget;

use Application\Admin\Dashboard\GoogleAnalyticsApiLoader;
use Application\Admin\Widget\WidgetInterface;
use Application\Core\I18n\Translation\Translator;

/**
 * Widget per Google Analytics.
 */
class VisitsReportWidget implements WidgetInterface
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var GoogleAnalyticsApiLoader
     */
    protected $api_loader;

    public function __construct(Translator $translator, GoogleAnalyticsApiLoader $api_loader)
    {
        $this->translator = $translator;
        $this->api_loader = $api_loader;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return 'ga-visits';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('Visitors overview');
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return 2;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        $container = $this->getKey() . '-container';

        return <<<HTML
{$this->api_loader->load()}

<style>
#{$container} {
    height: 360px;
}
#{$container} .chart {
    box-sizing: border-box;
    height: 300px;
}
#{$container} .reports {
    background: linear-gradient(to bottom, #fefefe 0%, #f2f3f2 100%);
    border-top: 1px solid #eee;
    clear: left;
    overflow: hidden;
}
#{$container} .reports__data {
    box-sizing: border-box;
    float: left;
    height: 60px;
    padding: 10px;
    width: 14.28%;
}
#{$container} .reports__data:hover {
    background: #fff;
    border-bottom-color: #b1b1b1;
}
#{$container} .reports__label {
    display: block;
    font-size: 11px;
}
#{$container} .reports__value {
    display: block;
    font-size: 18px;
    font-weight: bold;
    line-height: 26px;
}
</style>

<div id="{$container}" class="loading">
    <div class="chart"></div>
    <div class="reports"></div>
</div>
HTML;
    }
}
