<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Dashboard\Widget;

use Application\Admin\Dashboard\GoogleAnalyticsApiLoader;
use Application\Admin\Widget\WidgetInterface;
use Application\Core\I18n\Translation\Translator;

/**
 * @todo Aggiungere il base_url alle url del risultato
 */
class PageviewsReportWidget implements WidgetInterface
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var GoogleAnalyticsApiLoader
     */
    protected $api_loader;

    /**
     * @var
     */
    protected $base_url;

    /**
     * @param                          $base_url
     */
    public function __construct(Translator $translator, GoogleAnalyticsApiLoader $api_loader, $base_url)
    {
        $this->translator = $translator;
        $this->api_loader = $api_loader;
        $this->base_url = $base_url;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return 'ga-page-views';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('Most visited pages');
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return 1;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        $container = $this->getKey() . '-container';

        return <<<HTML
{$this->api_loader->load()}

<style>
#{$container} { height: 300px; }
#{$container} table { border-collapse: collapse; width: 100%; }
#{$container} th { background-color: #EEE; border-bottom: 1px solid #999; line-height: 29px; padding: 0 4px; text-align: left; }
#{$container} td { line-height: 27px; padding: 0 4px; }
#{$container} tr:nth-child(odd) td { background-color: #F6F6F6; }
</style>

<div id="{$container}" class="loading"></div>

<script>
var Pongho = Pongho || {};
Pongho.baseUrl = '{$this->base_url}';
Pongho.trans = Pongho.trans || {};

Pongho.trans.Page = '{$this->translator->trans('Page')}';
Pongho.trans.Visits = '{$this->translator->trans('Visits')}';
</script>
HTML;
    }
}
