<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Dashboard\Widget;

use Application\Admin\Dashboard\GoogleAnalyticsApiLoader;
use Application\Admin\Widget\WidgetInterface;
use Application\Core\I18n\Translation\Translator;

class LocationsReportWidget implements WidgetInterface
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var GoogleAnalyticsApiLoader
     */
    protected $api_loader;

    public function __construct(Translator $translator, GoogleAnalyticsApiLoader $api_loader)
    {
        $this->translator = $translator;
        $this->api_loader = $api_loader;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return 'ga-locations';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('Visits by country');
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return 1;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        $container = $this->getKey() . '-container';

        return <<<HTML
{$this->api_loader->load()}

<style>
#{$container} { height: 300px; }
</style>

<div id="{$container}" class="loading"></div>
HTML;
    }
}
