<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Controller;

use Application\Admin\Panels\PanelsManager;

/**
 * Controller per la bacheca.
 */
abstract class StatsController extends AdminController
{
    /**
     * @param string $method
     */
    public function __call($method, array $args)
    {
        if (!str_ends_with($method, 'Action')) {
            throw new \BadMethodCallException(sprintf('Method %s::%s not found!', self::class, $method));
        }

        $tab_name = substr($method, 0, -6);

        return $this->view($tab_name);
    }

    /**
     * @param string $tab
     */
    protected function view($tab = null)
    {
        $panels_manager = $this->getPanelsManager();

        if ($tab) {
            $panels_manager->setActive($tab);
        }

        $this->getHelper()->getBodyView()
            ->assignVars([
                'title'   => $this->getTitle(),
                'content' => $panels_manager->render(),
            ])
            ->setTemplatePath(__DIR__ . '/../Resources/views/view.php');

        $this->getHelper()
            ->addCss(pongho_url(
                '/Application/Admin/Resources/views/css/widgets.css'
                . filemtime(PONGHO_PATH . '/Application/Admin/Resources/views/css/widgets.css')
            ));

        return null;
    }

    /**
     * @return string
     */
    abstract protected function getTitle();

    /**
     * @return PanelsManager
     */
    abstract protected function getPanelsManager();
}
