<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Controller;

/**
 * Controller per la bacheca.
 */
class DashboardController extends AdminController
{
    /**
     * Azione `index`.
     */
    public function indexAction()
    {
        $translator = $this->getHelper()->getTranslator();

        if ($this->getHelper()->getUser()->isFounder()) {
            if (($this->getHelper()->getSite()->getOption('allow_robots') === false)) {
                $this->getHelper()->getBodyView()->assignVar(
                    'search_engines_disabled',
                    $translator->trans(
                        'Attention! The search engines can not access the site. You can enable their access from the <a href="%url%" title="SEO">SEO management</a> panel.',
                        ['%url%' => $this->url('/seo-general/')]
                    )
                );
            }

            if (($this->getHelper()->getSite()->getOption('google_analytics') === 'UA-XXXXX-XX')) {
                $this->getHelper()->getBodyView()->assignVar(
                    'google_analytics_disabled',
                    $translator->trans(
                        'Attention! The code for Google Analytics is not set. You can set it from the <a href="%url%" title="SEO">SEO management</a> panel.',
                        ['%url%' => $this->url('/seo-general/')]
                    )
                );
            }
        }

        $this->getHelper()
            ->addCss(pongho_url(
                '/Application/Admin/Resources/views/css/dashboard.css?v='
                . filemtime(PONGHO_PATH . '/Application/Admin/Resources/views/css/dashboard.css')
            ));

        $this->getHelper()->getBodyView()
            ->assignVar('widgets', $this->getWidgetsCollection())
            ->setTemplatePath(__DIR__ . '/../Resources/views/dashboard.php');
    }

    /**
     * Restituisce l’elenco dei widget.
     *
     * @return \Application\Admin\Widget\WidgetsCollection
     */
    protected function getWidgetsCollection()
    {
        return $this->getContainer()->get('admin_dashboard_widgets');
    }
}
