<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Archive;

use ActiveRecord\Base;

class QueryModel implements QueryInterface
{
    /**
     * @var string|Base
     */
    protected $model_class;

    /**
     * @var
     */
    protected $default_model_options;

    /**
     * @param string $model_class
     * @param array  $default_model_options
     */
    public function __construct($model_class, $default_model_options)
    {
        $this->model_class = $model_class;
        $this->default_model_options = $default_model_options;
    }

    /**
     * {@inheritdoc}
     */
    public function count(array $options)
    {
        $model_class = $this->model_class;

        return $model_class::count($options);
    }

    /**
     * {@inheritdoc}
     */
    public function all(array $options)
    {
        $model_class = $this->model_class;

        return $model_class::all($options);
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultQueryOptions()
    {
        return $this->default_model_options;
    }
}
