<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Archive;

class QueryManager implements QueryInterface
{
    /**
     * @var callable
     */
    private $all_callback;

    /**
     * @var callable
     */
    private $count_callback;

    /**
     * @var array
     */
    private $default_model_options;

    public function __construct(callable $count_callback, callable $all_callback, array $default_model_options)
    {
        $this->all_callback = $all_callback;
        $this->count_callback = $count_callback;
        $this->default_model_options = $default_model_options;
    }

    /**
     * {@inheritdoc}
     */
    public function count(array $options)
    {
        return call_user_func($this->count_callback, $options);
    }

    /**
     * {@inheritdoc}
     */
    public function all(array $options)
    {
        return call_user_func($this->all_callback, $options);
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultQueryOptions()
    {
        return $this->default_model_options;
    }
}
