<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Archive;

use Application\Core\I18n\Translation\Translator;
use Pongho\Menu\Item;
use Pongho\Menu\Menu;

class FastFilter implements FastFilterInterface
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var array
     */
    protected $filters;

    public function __construct(array $filters, Translator $translator)
    {
        $this->filters = $filters;
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function getFilters()
    {
        return $this->filters;
    }

    /**
     * {@inheritdoc}
     */
    public function buildMenu(array $totals = [], $active_item = null)
    {
        $label_tpl = '%s <span class="count">(%d)</span>';
        $filter_status = new Menu('filter-status');

        // Per ogni filtro rapido definito...
        foreach ($this->filters as $filter => $data) {
            $total = 0;
            if (isset($totals[$filter])) {
                $total = $totals[$filter];
            }

            // Inserisco l'elemento nel menu
            if ($filter === 'all' || $total) {
                $title = $this->translator->get('filter_status_' . $filter);
                $item = new Item(sprintf($label_tpl, $title, $total), $data['url'], ['title' => $title]);

                // Stato attivo
                if ($filter === $active_item) {
                    $item->setActive();
                }

                $filter_status->add($item);
            }
        }

        return $filter_status;
    }
}
