<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminSidebar;

use Pongho\Menu\Item as MenuItem;

class Item extends MenuItem
{
    /**
     * @var string
     */
    protected $controller;

    /**
     * @var int|null
     */
    protected $module_id;

    /**
     * @var string
     */
    protected $path;

    /**
     * @param string      $label
     * @param null|string $path
     * @param string      $url
     * @param string      $controller
     * @param int         $module_id
     */
    public function __construct($label, $path, $url, $controller, $module_id = null)
    {
        $this->controller = $controller;
        $this->module_id = $module_id;
        $this->path = $path;

        parent::__construct($label, $url);
    }

    /**
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @return int|null
     */
    public function getModuleId()
    {
        return $this->module_id;
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }
}
