<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminBar;

use Pongho\Core\TemplateResponse;

class AdminBarRenderer
{
    /**
     * @var AdminBarBuilder
     */
    protected $builder;

    public function __construct(AdminBarBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * @return TemplateResponse
     */
    public function render(TemplateResponse $response)
    {
        $content = $response->getContent();
        $bar = $this->builder->build();

        $code = $bar->render();
        $content = preg_replace('/<body(.*?)>/', '$0' . $code, $content);

        $response->setContent($content);

        return $response;
    }
}
