<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminBar;

use Pongho\Menu\Menu;

/**
 * È la base per la realizzazione della barra di amministrazione di Pongho.
 */
class AdminBar
{
    /**
     * Menu di sinistra.
     *
     * @var \Pongho\Menu\MenuInterface
     */
    public $left;

    /**
     * Menu di destra.
     *
     * @var \Pongho\Menu\MenuInterface
     */
    public $right;

    /**
     * @var string
     */
    protected $js = '';

    /**
     * @var string
     */
    protected $css = '';

    /**
     * @var string
     */
    protected $html = '';

    public function __construct()
    {
        $this->left = new Menu('left');
        $this->right = new Menu('right');
    }

    /**
     * @return string
     */
    public function render()
    {
        $js = $this->getJsCode() . $this->js;
        $css = $this->getCssCode() . $this->css;
        $html = $this->getHtmlCode() . $this->html;

        return <<<HTML
<script>{$js}</script>
<style>{$css}</style>
{$html}
HTML;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function addJs($code)
    {
        $this->js .= $code;

        return $this;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function addCss($code)
    {
        $this->css .= $code;

        return $this;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function addHtml($code)
    {
        $this->html .= $code;

        return $this;
    }

    /**
     * @return string
     */
    private function getCssCode()
    {
        return file_get_contents(__DIR__ . '/../Resources/public/adminbar/adminbar.css');
    }

    /**
     * @return string
     */
    private function getJsCode()
    {
        return <<<JS
document.getElementsByTagName('html')[0].className+=' admin-bar';
document.getElementsByTagName('body')[0].className+=' admin-bar';
JS;
    }

    private function getHtmlCode()
    {
        $left = $this->left->render();
        $right = $this->right->render();

        return <<<HTML
<div id="pongho-admin-bar">
    <ul id="pongho-admin-bar-left">{$left}</ul>
    <ul id="pongho-admin-bar-right">{$right}</ul>
</div>
HTML;
    }
}
