<?php

/*
 * This file is part of the Meta Line CookieBar package.
 *
 * (c) Web Agency Meta Line S.r.l.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MetaLine\GDPR;

/**
 * HtmlParser
 */
class HtmlParser
{
    /**
     * @var Collection
     */
    public $javascriptBlackList;

    /**
     * @var Collection
     */
    public $iframeWhiteList;

    /**
     * @var string
     */
    private $cookieName;

    /**
     * @var ParserInterface
     */
    private $parser;

    public function __construct(string $cookieName = 'cookie_consent', ParserInterface $parser = null)
    {
        $this->cookieName = $cookieName;

        $this->javascriptBlackList = new Collection([
            // script src
            'platform.twitter.com/widgets.js',
            'apis.google.com/js/plusone.js',
            'apis.google.com/js/platform.js',
            'connect.facebook.net',
            'www.youtube.com/iframe_api',
            'pagead2.googlesyndication.com/pagead/js/adsbygoogle.js',
            'sharethis.com/button/buttons.js',
            'addthis.com/js/',
            'google.com/recaptcha',
            'disqus.com/embed.js',
            'sharethis.com/button/buttons.js',

            // script inline
            'window.adsbygoogle'
        ]);

        $this->iframeWhiteList = new Collection([
            'youtube-nocookie.com',
        ]);

        $this->parser = $parser ?: new ParserDom();
    }

    public function parse(string $content): string
    {
        if ($this->isCookiePolicyAccepted()) {
            return $content;
        }

        if (strpos($content, '<html') === false) {
            return $content;
        }

        return $this->parser->parse(
            $content,
            $this->iframeWhiteList,
            $this->javascriptBlackList
        );
    }

    protected function isCookiePolicyAccepted(): bool
    {
        return isset($_COOKIE[$this->cookieName]) && $_COOKIE[$this->cookieName];
    }
}
