<?php

/*
 * This file is part of the Meta Line CookieBar package.
 *
 * (c) Web Agency Meta Line S.r.l.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MetaLine\GDPR;

class Collection
{
    /**
     * @var string[]
     */
    private $list;

    /**
     * @param string[] $list
     */
    public function __construct(array $list = [])
    {
        $this->list = $list;
    }

    public function add(string $string): self
    {
        $this->list[] = $string;

        return $this;
    }

    public function remove(string $string): self
    {
        foreach ($this->list as $index => $item) {
            if ($string === $item) {
                unset($this->list[$index]);

                return $this;
            }
        }

        return $this;
    }

    /**
     * @return string[]
     */
    public function all(): array
    {
        return $this->list;
    }

    public function isPresent(string $string): bool
    {
        foreach ($this->list as $item) {
            if (strpos($string, $item) !== false) {
                return true;
            }
        }

        return false;
    }
}
