<?php

/**
 * This library is PSR-4 compliant. Include this file only if you do not use Composer.
 *
 * @see https://www.php-fig.org/psr/psr-4/
 * @see https://www.php-fig.org/psr/psr-4/examples/
 * @see https://getcomposer.org/
 */

spl_autoload_register(function ($class) {
    $prefix = 'MetaLine\\GDPR\\';
    $baseDir = __DIR__ . '/src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // move to the next registered autoloader
        return;
    }

    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});
