# Cookie Bar - HTML Parser

Questa libreria fornisce un sistema per impedire agli `<iframe>` e ai `<script>` presenti in una pagina HTML di inviare cookie al browser.

## Installazione

Per prima cosa, devi scaricare la libreria ed inserirla all’interno del tuo sito, ad esempio nella cartella `cookie-bar-html-parser`. A questo punto, a seconda della piattaforma con la quale è sviluppato il tuo sito, devi raccogliere l’output della pagina ed elaborarlo con la classe `HtmlParser`. Troppo difficile? Nah...

### Generale

In generale, devi aggiungere questo snippet all‘inizio di tutti i file PHP che restituiscono un codice HTML:

```php
// Correggi il percorso a seconda di dove hai inserito la libreria
require_once __DIR__ . '/cookie-bar-html-parser/autoload.php';

$htmlParser = new \MetaLine\GDPR\HtmlParser();
ob_start(array($htmlParser, 'parse'));
```

### WordPress

Aggiungi questo codice nel file functions.php del tuo tema:

```php
function cookie_bar_html_parser() {
    if (is_admin()) {
        return;
    }
	
    // Correggi il percorso a seconda di dove hai inserito la libreria
    require_once __DIR__ . '/cookie-bar-html-parser/autoload.php';

    $htmlParser = new \MetaLine\GDPR\HtmlParser();
    ob_start(array($htmlParser, 'parse'));
}

add_action('init', 'cookie_bar_html_parser');
```

### Prestashop

Crea questo file al percorso `./override/classes/controller/FrontController.php`:

```php
<?php

// Correggi il percorso a seconda di dove hai inserito la libreria
require_once __DIR__ . '/cookie-bar-html-parser/autoload.php';

class FrontController extends FrontControllerCore
{
    public function display()
    {
        $htmlParser = new \MetaLine\GDPR\HtmlParser();
        ob_start(array($htmlParser, 'parse'));

        parent::display();
    }
}
```

Se il file esiste già, devi adattare il codice.

Ricordati di pulire la cache!

## Come funziona

Il parser elabora il codice HTML prodotto dalla pagina per manipolare i tag `<script>` e `<iframe>` in quanto potrebbero generare cookie. La manipolazione è diversa a seconda del tag.

### script

La maggior parte dei tag `<script>` non genera cookie, quindi è stato scelto un approccio a blacklist. Questo significa che vengono manipolati solo i tag che contengono nell’attributo `src` o nel contenuto del tag, uno degli elementi presenti in `$htmlParser->javascriptBlackList`.

La conversione consiste in queste manipolazioni:

- L’attributo `src`, se presente, viene convertito in `data-src`
- L’attributo `type` viene forzato al valore `text/plain`
- Viene aggiunta la classe `_gdpr_script_src` nel caso sia uno script che carica un file esterno
- Viene aggiunta la classe `_gdpr_script_inline` nel caso sia uno script inline

### iframe

La maggior parte dei tag `<iframe>` genera cookie, quindi è stato scelto un approccio a whitelist. Questo significa che vengono manipolati tutti i tag, tranne quelli che contengono nell’attributo `src` uno degli elementi presenti in `$htmlParser->iframeWhiteList`.

La conversione consiste in queste manipolazioni:

- L’attributo `src` viene convertito in `data-src`
- Viene aggiunta la classe `_gdpr_iframe`

## Personalizzazioni

### Nome del cookie di controllo

Per capire se il codice HTML deve essere elaborato o meno, la libreria verifica la presenza di un cookie chiamato `cookie_policy`. Questo nome può essere personalizzato passandolo al costruttore della classe:

```php
$htmlParser = new \MetaLine\GDPR\HtmlParser('my_custom_name');
```

### Modificare la blacklist per i tag `<script>`

Il parser viene istanziato con una blacklist precompilata dei tag più comuni. È possibile aggiungere nuovi elementi in questo modo:

```php
$htmlParser->javascriptBlackList->add('script-che-genera-cookie.js');
```

### Modificare la whitelist per i tag `<iframe>`

Il parser viene istanziato con una whitelist precompilata dei tag più comuni. È possibile aggiungere nuovi elementi in questo modo:

```php
$htmlParser->iframeWhiteList->add('iframe-che-non-genera-cookie.html');
```

### Verifica della presenza del cookie di controllo

Di default la classe fa uso della variabile globale `$_COOKIE`. Ci sono casi in cui questo deve essere personalizzato, ad esempio se si sta lavorando con Symfony o altri framework che hanno una loro astrazione della richiesta HTTP. Per farlo, basta estendere la classe e sfruttare il metodo `isCookiePolicyAccepted()`.

### Cambiare il parser interno

Internamente la libreria fa uso di un parser che può essere personalizzato attraverso il secondo parametro del costruttore di `HtmlParser`. È disponibile ad esempio un parser che agisce attraverso le regex:

```php
$htmlParser = new \MetaLine\GDPR\HtmlParser('cookie_policy', new \MetaLine\GDPR\ParserRegex());
```
